<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%
	String path = request.getContextPath();
	String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort()
			+ path + "/";
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
<base href="<%=basePath%>" />

<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/mta/css/index.css" />
<script src="<%=request.getContextPath()%>/resources/js/jquery-easyui-1.4/jquery.min.js" type="text/javascript"></script>
<script src="<%= request.getContextPath()%>/resources/js/ajax-pushlet-client.js" type="text/javascript"></script>
<script type="text/javascript">
	var baseUrl='<%= request.getContextPath()%>';
	var loginUserId='${sessionScope.user.userid}'; 
	var language="<%=session.getAttribute("language")%>"; 
	if (language.indexOf('en') > -1) {
		document.write("<script src='" + baseUrl + "/resources/js/mta_en/index.js'><\/script>");
	} else {
		// 默认中文
		document.write("<script src='" + baseUrl + "/resources/js/mta/index.js'><\/script>");
	}
</script>
</head>

<body>
	<div id="header">
	<c:import url="header.jsp"></c:import>
	</div>
	<input type="hidden"  id="userId" name="userId" value="${sessionScope.user.userid}"></input>
	<div id="banner">
		<img src="<%=request.getContextPath()%>/resources/mta/img/index/flash.jpg" class="w" />
	</div>
	<div id="main" class="w">
		<div class="main_left l">
			<div class="title">
				<!-- 课程分类 -->
				<spring:message code="lable.title.kecheng"/>
				<div class="triangle-down"></div>
			</div>
			<ul class="classify" id="courseTypeUl">
			</ul>
		</div>
		<div class="main_center l"  id="courseListDiv">
		</div>
		<div class="main_right r">
			<c:if test="${sessionScope.user!=null}">
			<div class="day_test">
				<div class="title">
				<!-- 每日一练 -->
				<spring:message code="label.font.daytest"/>
				</div>
				<ul class="list" id="dailyPractice">
				</ul>
			</div>
			</c:if>
			<div class="news">
				<div class="title">
					<!-- 最新动态 -->
					<spring:message code="label.index.news"/>
				</div>
				<ul class="list" id="sysMsg">
				</ul>
			</div>
			<div class="ranking">
				<ul class="title" id="rankingTitle">
					<li class="l active" id="ZR">
						<!--最热排行 -->
						<spring:message code="label.index.zrsort"/>
					</li>
					<li class="l" id="ZX">
						<!--最新排行 -->
						<spring:message code="label.index.zxsort"/>
					</li>
				</ul>
				<ul class="list" id="cardZR">
				</ul>
				<ul class="list" id="cardZX" style="display:none">
				</ul>
			</div>
		</div>
		
		<div class="exam w">
			<h3 class="title">
				<span>
					<!--热门考试 -->
					<spring:message code="label.index.hotexam"/>
				</span>
				<a href="<%= request.getContextPath()%>/mta/F020/Exam.html" class="more r">
					<!--更多 -->
					<spring:message code="label.index.more"/>
				</a>
			</h3>
			<img src="<%=request.getContextPath()%>/resources/mta/img/index/exam.jpg" class="l left-img" />
			<ul class="list" id="ksInfromation">
				
			</ul>
		</div>
		<div class="resource w">
			<h3 class="title">
				<span>
					<!-- 资源库 -->
					<spring:message code="label.index.resource"/>
				</span> 
				<a href="<%= request.getContextPath()%>/mta/F030/Resources.html" class="more r">
					<!--更多 -->
					<spring:message code="label.index.more"/>
				</a>
			</h3>
			<img src="<%=request.getContextPath()%>/resources/mta/img/index/resource.jpg" class="l left-img" />
			<ul class="list l" id="resourceList">
			</ul>
		</div>
	</div>
	<div id="footer">
	<c:import url="footer.jsp"></c:import>
	</div>
</body>
</html>